@extends('admin.layouts.master')

@section('extra_css')
    <link rel="stylesheet" type="text/css" href="/assets/plugins/select2/select2.css"/>
    <link rel="stylesheet" type="text/css"
          href="/assets/plugins/datatables/extensions/Scroller/css/dataTables.scroller.min.css"/>
    <link rel="stylesheet" type="text/css"
          href="/assets/plugins/datatables/extensions/ColReorder/css/dataTables.colReorder.min.css"/>
    <link rel="stylesheet" type="text/css"
          href="/assets/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.css"/>
@stop

@section('extra_js')
    <script type="text/javascript" src="/assets/plugins/select2/select2.min.js"></script>
    <script type="text/javascript" src="/assets/plugins/datatables/media/js/jquery.dataTables.min.js"></script>
    <script type="text/javascript"
            src="/assets/plugins/datatables/extensions/TableTools/js/dataTables.tableTools.min.js"></script>
    <script type="text/javascript"
            src="/assets/plugins/datatables/extensions/ColReorder/js/dataTables.colReorder.min.js"></script>
    <script type="text/javascript"
            src="/assets/plugins/datatables/extensions/Scroller/js/dataTables.scroller.min.js"></script>
    <script type="text/javascript" src="/assets/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.js"></script>
    <script type="text/javascript">
        $(document).ready(function () {
            Metronic.handleTables();
        });
    </script>
@stop

@section('content')

    <h3 class="page-title">
        Categories <small>Manage Categories</small>
    </h3>

    <div class="page-bar">
        <ul class="page-breadcrumb">

            <li>
                <a href="/admin">Home</a>
                <i class="fa fa-angle-right"></i>
            </li>
            <li>
                <a href="/admin/categories">Categories</a>
            </li>

        </ul>
    </div>


    <!-- END PAGE HEADER-->
    <!-- BEGIN PAGE CONTENT-->
    <div class="row">
        <div class="col-md-12">
            <!-- BEGIN PORTLET-->
            <div class="portlet box green-meadow">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="icon-puzzle"></i>All Categories
                    </div>
                    <div class="actions">
                        <a href="/admin/categories/create" class="btn red">
                            <i class="fa fa-plus"></i> Create New Category </a>
                    </div>
                </div>

                <div class="portlet-body">

                    @include('admin.layouts.notify')

                    <table class="table table-striped table-bordered table-hover" id="datatable_advanced">
                        <thead>
                        <tr>
                            <th>
                                Name
                            </th>
                            {{--<th>--}}
                                {{--Scroll Type--}}
                            {{--</th>--}}
                            <th>
                                Show in menu
                            </th>
                            <th>
                                Show in sidebar
                            </th>
                            <th>
                                Show in footer
                            </th>
                            <th>
                                SEO Keywords
                            </th>
                            <th>
                                SEO Description
                            </th>
                            <th>Sources</th>
                            <th>Posts</th>
                            <th>Edit</th>
                            <th>Delete</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($categories as $category)
                            <tr>
                                <td> {{$category->title}} </td>
                                {{--<td> {{$category->scroll_type}} </td>--}}
                                <td> {{$category->show_in_menu ? 'Yes':'No'}} </td>
                                <td> {{$category->show_in_sidebar ? 'Yes':'No'}} </td>
                                <td> {{$category->show_in_footer ? 'Yes':'No'}} </td>
                                <td> {{$category->seo_keywords }} </td>
                                <td> {{$category->seo_description }} </td>
                                <td> {{$category->no_sources }} </td>
                                <td> {{$category->no_posts }} </td>
                                <td><a href="/admin/categories/edit/{{$category->id}}" class="btn btn-warning btn-sm">Edit</a>
                                </td>
                                <td><a data-href="/admin/categories/delete/{{$category->id}}" data-toggle="modal"
                                       data-target="#confirm-delete" class="btn btn-danger btn-sm">Delete</a></td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>

                    <div class="modal fade" id="confirm-delete" tabindex="-1" role="dialog"
                         aria-labelledby="myModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    Delete Category ?
                                </div>
                                <div class="modal-body" style="background-color:#FFB848; color:#ffffff;">
                                    <h4><i class="fa fa-exclamation-triangle"></i> Are you sure that you want to delete
                                        this Category ? It will delete all sources linked to it and it cannot be undone
                                    </h4>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                    <a class="btn btn-danger btn-ok">Delete</a>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
            <!-- END PORTLET-->
        </div>
    </div>
@stop